!!****if* source/Simulation/SimulationMain/Sedov/Grid_computeUserVars
!!
!! NAME
!!  Grid_computeUserVars
!!
!!
!! SYNOPSIS
!!
!!  call Grid_computeUserVars() 
!!
!!  
!! DESCRIPTION 
!!  
!!  Prepare user variables for output.
!!
!! ARGUMENTS 
!!  none
!!  
!! EXAMPLE
!!
!!
!!
!! NOTES
!!  
!!***

subroutine Grid_computeUserVars()
  use Simulation_interface, ONLY: Simulation_computeAnalytical
  use Driver_data,         ONLY : dr_simGeneration
  use Timers_interface, ONLY : Timers_start, Timers_stop
  use Grid_interface, ONLY : Grid_getLocalNumBlks, &
    Grid_getCellCoords,     Grid_coordTransfm, &
    Grid_getListOfBlocks, &
    Grid_getBlkIndexLimits, Grid_getBlkPtr, &
    Grid_releaseBlkPtr
  use Driver_interface, ONLY: Driver_getSimTime
  use Simulation_data, ONLY: sim_grGeometry, sim_confGeometry
  implicit none

#include "Flash.h"
#include "constants.h"
  
  real    :: tnew
  integer :: simGen
  integer :: lb, blockID
  integer :: i, j, k, n
  real :: X , Y ,  Z , xxL, xxR
  real :: xx, yy,  zz, xxMin, xxMax
  real :: Xign,Yign,Zign
  
  real,allocatable, dimension(:) ::xCenter,yCoord,zCoord

  integer :: localNumBlocks, blockCount

  integer,allocatable,dimension(:) :: blockList
  integer,dimension(2,MDIM) :: bl,blkLimitsGC
  integer :: sizeX,sizeY,sizeZ
  real :: velxZone, velyZone, velzZone, & 
          velxxZone, velyyZone, velzzZone
  real, pointer, dimension(:,:,:,:) :: solnData

  call Timers_start("computeUserVars")
  call Driver_getSimTime(tnew, simGen)

  call Grid_getLocalNumBlks(localNumBlocks)
  allocate(blockList(localNumBlocks))
  call Grid_getListOfBlocks(LEAF,blockList,blockCount)

  do lb=1,blockCount
     blockID = blockList(lb)

#if defined(VLCX_VAR) || defined(VLCY_VAR) || defined(VLCZ_VAR)
     call Grid_getBlkIndexLimits(blockID,bl,blkLimitsGC)

     sizeX = blkLimitsGC(HIGH,IAXIS)
     sizeY = blkLimitsGC(HIGH,JAXIS)
     sizeZ = blkLimitsGC(HIGH,KAXIS)
     allocate(xCenter(sizeX))
     allocate(yCoord(sizeY))
     allocate(zCoord(sizeZ))
     xCenter = 0.0
     yCoord = 0.0
     zCoord = 0.0

     if (NDIM == 3) call Grid_getCellCoords&
          (KAXIS, blockId, CENTER,.TRUE., zCoord, sizeZ)
     if (NDIM >= 2) call Grid_getCellCoords&
          (JAXIS, blockId, CENTER,.TRUE., yCoord, sizeY)

     call Grid_getCellCoords(IAXIS, blockId, CENTER, .TRUE., xCenter, sizeX)

     call Grid_getBlkPtr(blockID,solnData)     

! Name convention:
! X,Y,Z    refer to values of coordinates the FLASH IAXIS,JAXIS,KAXiS directions,
!          i.e., the coordinate geometry (cf. Users Guide on "Grid Geometry")
! xx,yy,zz refer to values of the "physical" coordinates

     do k = bl(LOW,KAXIS),bl(HIGH,KAXIS)

        ! get the coordinates of the cell center in the Z-direction
        Z  = zCoord(k)

        do j = bl(LOW,JAXIS),bl(HIGH,JAXIS)

           ! get the coordinates of the cell center in the y-direction
           Y  = yCoord(j)

           do i = bl(LOW,IAXIS),bl(HIGH,IAXIS)

              ! get the cell center, left, and right positions in x
              X   = xCenter(i)

              velxZone = solnData(VELX_VAR,i,j,k)
              velyZone = solnData(VELY_VAR,i,j,k)
              velzZone = solnData(VELZ_VAR,i,j,k)
              call Grid_coordTransfm(X,   Y,Z,  xx,  yy,  zz,   sim_grGeometry,sim_confGeometry,3, &
                velxZone,velyZone,velzZone, velxxZone,velyyZone,velzzZone)
!              call Grid_coordTransfm(xx, yy,zz, Xign,Yign,Zign, sim_confGeometry,sim_grGeometry,3, &

#ifdef VLCX_VAR
              solnData(VLCX_VAR,i,j,k) = velxxZone
#endif
#ifdef VLCY_VAR
              solnData(VLCY_VAR,i,j,k) = velyyZone
#endif
#ifdef VLCZ_VAR
              solnData(VLCZ_VAR,i,j,k) = velzzZone
#endif
           end do
        end do
     end do

     deallocate(xCenter)
     deallocate(yCoord)
     deallocate(zCoord)

     call Grid_releaseBlkPtr(blockID,solnData)
#endif
  end do

  deallocate(blockList)
  dr_simGeneration = simGen + 1
  call Timers_stop("computeUserVars")

end subroutine Grid_computeUserVars
